$(function(){
    $.get( '/data.csv', function(data) {
        Papa.parse(data, {
            header: true,
            dynamicTyping: true,
            complete: function(results) {
                processCoachingData(results.data);
            }
        });
    });
});



window.week_introductions = {
    gain_muscle: {
        week_1: 'Un bon apport protéique à chaque repas aide à renouveler les cellules bâtisseuses des muscles : viandes, poissons, oeufs, produits laitiers.',
        week_2: 'Variez vos petits déjeuners et introduisez-y des protéines qui contribuent à booster votre potentiel musculaire :  produits laitiers, jambon ou oeuf.',
        week_3: 'Question de timing : avant de pratiquer une activité physique, évitez de consommer des aliments qui provoquent des ballonnements (crudités, féculents).',
        week_4: 'Pour éviter les risques de courbatures douloureuses, pensez à boire une eau pétillante riche en bicarbonate après votre activité physique.'
    },
    tone_up: {
        week_1: 'Si vous vous fixez de petits objectifs réalisables et mesurables au quotidien, ce sera bien plus facile d’atteindre votre objectif principal.',
        week_2: 'Quand vous faites vos courses, pensez à remplir le frigo de produits frais plutôt que le placard de produits secs, salés ou sucrés.',
        week_3: 'Ne laissez pas entrer chez vous les gourmandises auxquelles vous ne sauriez pas    résister et qui vous empêcheraient d’atteindre votre objectif.',
        week_4: 'Identifiez les émotions et les situations qui vous incitent à manger sans faim pour les anticiper et continuer à vous affiner dans la durée.'
    },
    stabilize: {
        week_1: 'Continuez à faire la différence entre la faim et l’envie de manger, mais aussi à savoir vous arrêter dès que vous sentez que ça suffit comme ça.',
        week_2: 'Pensez à boire régulièrement tout au long de la journée de l’eau plate ou gazeuse, fraîche ou à température et limitez les boissons sucrées.',
        week_3: 'Ne paniquez pas si vous avez fait un repas trop riche ou trop copieux : attendez d’avoir faim à nouveau et régulez en allégeant le repas suivant.',
        week_4: 'Apprenez à cuisiner selon vos propres goûts et besoins : les bons petits plats maison sont moins gras, salés, sucrés que les plats préparés.'
    },
    lose_weight: {
        week_1: 'Prenez votre temps pour perdre du poids de façon progressive, sans vous bousculer ni vous priver de tout : ce sera plus agréable et durable.',
        week_2: 'Si vous avez l’impression d’avoir tout le temps faim, augmentez la proportion d’aliments complets riches en fibres qui vous rassasient.',
        week_3: 'Notez avec soin tout ce que vous mangez dans un petit carnet : vous vous rendrez mieux compte de vos extras, de vos excès et de vos progrès.',
        week_4: 'Organisez vos placards et votre frigo pour pouvoir grignoter malin si besoin sans risquer d’avoir sous la main des aliments-tentation.'
    },
    gain_weight: {
        week_1: 'Ouvrez-vous l’appétit en dressant une jolie table, variez les mets et les plaisirs en petites quantités et mettez au menu vos aliments préférés.',
        week_2: 'Mangez des féculents à chaque repas : profitez-en pour découvrir toute la variété des céréales bio, complètes, et les légumineuses à la mode.',
        week_3: 'Donnez du goût à vos plats à l’aide de toutes les épices et les aromates des cuisines du monde et d’un filet de matières grasses bien choisies.',
        week_4: 'Pensez à sortir prendre l’air et respirer avant de vous mettre à table : c’est la meilleure et la plus saine façon de vous ouvrir l’appétit.'
    }
};

function processCoachingData(data) {

    var activeCategory = getUrlParameter('category');
    var activeWeek = getUrlParameter('week');
    var tree = {};

    var categoryType, weekType, dayType, periodType, objective;

    data.map(function(row) {
        weekType = 'week_' + row.week;
        categoryType = row.type;
        objective = row.objectif
        dayType = 'day_' + row.day;
        periodType = row.period;

        if (objective !== '' && objective !== undefined && objective !== null)
            objective = objective.trim();

        // check line is complete and is not another header line :
        if (categoryType === '' || categoryType === undefined || categoryType === null ||
          dayType === '' || dayType === undefined || dayType === null ||
          weekType === '' || weekType === undefined  || weekType === null ||
          periodType === '' || periodType === undefined || periodType === null ||
          objective !== 'nutrition'
        )
            return;


        periodType = periodType.trim();
        categoryType = categoryType.trim();
        dayType = dayType.trim();
        weekType = weekType.trim();


        if (activeCategory === 'ideal_weight' && ('gain_weight' === categoryType || 'lose_weight' === categoryType))
            categoryType = 'ideal_weight';

        if (activeCategory !== '' && activeCategory !== categoryType)
            return;

        if (!(categoryType in tree))
            tree[categoryType] = {};

        if (activeWeek !== '' && activeWeek !== weekType)
            return;

        if (!(weekType in tree[categoryType]))
            tree[categoryType][weekType] = {};

        if (!(dayType in tree[categoryType][weekType]))
            tree[categoryType][weekType][dayType] = {};

        if (!(periodType in tree[categoryType][weekType][dayType]))
            tree[categoryType][weekType][dayType][periodType] = [];

        tree[categoryType][weekType][dayType][periodType].push({
            title: row.title,
            link: row.link,
            image: row.image,
        });
    });

    $(window).trigger('coachingDataReady', [tree, activeCategory, activeWeek]);
    return tree;
}

function getUrlParameter(name) {
    name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
    var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
    var results = regex.exec(location.search);
    return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
}