$(function(){
    $.get( 'data.csv', function(data) {
        Papa.parse(data, {
            header: true,
            dynamicTyping: true,
            complete: function(results) {
                processCoachingData(results.data);
            }
        });
    });
});



window.week_introductions = {
    gain_muscle: {
        week_1: 'Un buon apporto proteico a ogni pasto aiuta a rinnovare le cellule che formano i muscoli: carne, pesce, uova, latticini.',
        week_2: 'Varia la colazione e introduci proteine che contribuiscono a potenziare i muscoli: latticini, prosciutto o uova.',
        week_3: 'Questione di timing: prima di praticare un’attività fisica, evita di consumare alimenti che provocano gonfiore addominale (insalata, farinacei)',
        week_4: 'Per evitare il rischio di irrigidimenti dolorosi, cerca di bere acqua frizzante, ricca di bicarbonato, subito dopo l’attività fisica.'
    },
    tone_up: {
        week_1: 'Se fissi piccoli obiettivi realizzabili e compatibili con la tua vita quotidiana, sarà molto più facile raggiungere il tuo obiettivo principale.',
        week_2: 'Quando fai la spesa, cerca di riempire il frigo di prodotti freschi anziché prodotti essiccati, salati o zuccherati.',
        week_3: 'Non tenere in casa golosità alle quali non sapresti resistere e che ti impedirebbero di raggiungere il tuo obiettivo.',
        week_4: 'Individua le emozioni e le situazioni che ti spingono a mangiare senza avere veramente fame per prevenirle e continuare ad affinare la tua silhouette in modo costante.'
    },
    stabilize: {
        week_1: 'Continua a percepire la differenza fra la fame e la voglia di mangiare, ma anche a fermarti non appena senti che hai mangiato a sufficienza.',
        week_2: 'Cerca di bere regolarmente per tutto il giorno acqua naturale o gassata, fresca o a temperatura ambiente, e limita le bevande zuccherate.',
        week_3: 'Non preoccuparti troppo se hai consumato un pasto troppo ricco o troppo abbondante: aspetta di avere nuovamente fame e regolati alleggerendo il pasto seguente.',
        week_4: 'Impara a cucinare in base ai tuoi gusti e alle tue esigenze: un buon piccolo piatto fatto in casa è meno grasso, salato e zuccherato di quelli già preparati.'
    },
    lose_weight: {
        week_1: 'Prenditi il tuo tempo per perdere peso in modo progressivo, senza pressioni e senza privarti di tutto; sarà più piacevole e duraturo.',
        week_2: 'Se hai l’impressione di avere sempre fame, aumenta la proporzione di alimenti integrali ricchi di fibre, che ti sazieranno.',
        week_3: 'Annota tutto ciò che mangi in un quaderno: avrai un’idea più chiara dei tuoi extra, degli eccessi e dei progressi.',
        week_4: 'Organizza i tuoi scaffali e il frigo per poter mangiucchiare in modo intelligente se necessario, senza rischiare di avere a portata di mano alimenti tentatori.'
    },
    gain_weight: {
        week_1: 'Fatti venire l’appetito apparecchiando bene la tavola; varia i piatti e i piaceri in piccole quantità e inserisci nel menù i tuoi alimenti preferiti.',
        week_2: 'Mangia farinacei a ogni pasto: approfittane per scoprire tutta la varietà dei cereali bio, integrali e i legumi più amati.',
        week_3: 'Dai gusto ai tuoi piatti con l’aiuto di tutte le spezie e gli aromi delle cucine del mondo e un pizzico di grassi ben selezionati.',
        week_4: 'Cerca di prendere una boccata di aria fresca prima di metterti a tavola: è il modo migliore e più sano per farti venire l’appetito.'
    }
};

function processCoachingData(data) {

    var activeCategory = getUrlParameter('category');
    var activeWeek = getUrlParameter('week');
    var tree = {};

    var categoryType, weekType, dayType, periodType, objective;

    data.map(function(row) {
        weekType = 'week_' + row.week;
        categoryType = row.type;
        objective = row.objectif
        dayType = 'day_' + row.day;
        periodType = row.period;

        if (objective !== '' && objective !== undefined && objective !== null)
            objective = objective.trim();

        // check line is complete and is not another header line :
        if (categoryType === '' || categoryType === undefined || categoryType === null ||
          dayType === '' || dayType === undefined || dayType === null ||
          weekType === '' || weekType === undefined  || weekType === null ||
          periodType === '' || periodType === undefined || periodType === null ||
          objective !== 'nutrition'
        )
            return;


        periodType = periodType.trim();
        categoryType = categoryType.trim();
        dayType = dayType.trim();
        weekType = weekType.trim();


        if (activeCategory === 'ideal_weight' && ('gain_weight' === categoryType || 'lose_weight' === categoryType))
            categoryType = 'ideal_weight';

        if (activeCategory !== '' && activeCategory !== categoryType)
            return;

        if (!(categoryType in tree))
            tree[categoryType] = {};

        if (activeWeek !== '' && activeWeek !== weekType)
            return;

        if (!(weekType in tree[categoryType]))
            tree[categoryType][weekType] = {};

        if (!(dayType in tree[categoryType][weekType]))
            tree[categoryType][weekType][dayType] = {};

        if (!(periodType in tree[categoryType][weekType][dayType]))
            tree[categoryType][weekType][dayType][periodType] = [];

        tree[categoryType][weekType][dayType][periodType].push({
            title: row.title,
            link: row.link,
            image: row.image,
        });
    });

    $(window).trigger('coachingDataReady', [tree, activeCategory, activeWeek]);
    return tree;
}

function getUrlParameter(name) {
    name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
    var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
    var results = regex.exec(location.search);
    return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
}
