$(function(){
    $.get( '/data.csv', function(data) {
        Papa.parse(data, {
            header: true,
            dynamicTyping: true,
            complete: function(results) {
                processCoachingData(results.data);
            }
        });
    });
});



window.week_introductions = {
    gain_muscle: {
        week_1: 'Een goede eiwitverhouding bij elke maaltijd helpt om de bouwcellen voor de spieren te vernieuwen: vlees, vis, eieren, zuivelproducten.',
        week_2: 'Varieer uw ontbijt en start met het toevoegen van eiwitten die bijdragen aan het bevorderen van uw spierpotentieel: zuivelproducten, ham of ei.',
        week_3: 'Kwestie van timing: vermijd het gebruik van voedingsstoffen die een opgeblazen gevoel bevorderen (rauwkost, zetmeelhoudende producten) voordat u een fysieke activiteit gaat beoefenen.',
        week_4: 'Om de risico’s op een pijnlijke spierkater te voorkomen, drinkt u na uw fysieke activiteit bruisend water dat rijk is aan bicarbonaat.'
    },
    tone_up: {
        week_1: 'Als u kleine doelstellingen vastlegt die haalbaar en meetbaar zijn in het dagelijks leven, is het een stuk eenvoudiger om uw hoofddoel te bereiken.',
        week_2: 'Wanneer u boodschappen doet, vul dan uw koelkast met verse producten in plaats van uw kast met gedroogde, gezouten of gezoete producten.',
        week_3: 'Haal geen lekkere dingen in huis waarvan u weet dat u ze niet kunt weerstaan en die u ervan weerhouden uw doel te bereiken.',
        week_4: 'Benoem de emoties en de situaties die u aanzetten tot eten terwijl u geen honger hebt, zodat u hierop kunt inspelen en door kunt zetten.'
    },
    stabilize: {
        week_1: 'Blijf het verschil maken tussen honger en zin om te eten, maar blijf ook stoppen wanneer u weet dat u genoeg hebt gehad.',
        week_2: 'Onthoud goed om de hele dag door water (kraan- of bruisend water) te drinken, gekoeld of op kamertemperatuur, en beperk zoete drankjes.',
        week_3: 'Raak niet in paniek wanneer u een te rijke of te grote maaltijd bereidt: wacht tot u opnieuw honger krijgt en maak de volgende maaltijd lichter.',
        week_4: 'Leer te koken volgens uw eigen smaken en behoeften: zelfgemaakte maaltijden zijn minder vet, zout en zoet dan kant-en-klaar-maaltijden.'
    },
    lose_weight: {
        week_1: 'Neem de tijd om op een progressieve manier af te vallen, zonder uw eetpatroon compleet te veranderen en u alles te ontzeggen: dat is veel aangenamer en blijvender.',
        week_2: 'Als u de indruk hebt de hele tijd honger te hebben, vergroot dan de porties vezelrijke, volwaardige voedingsmiddelen die u verzadigen.',
        week_3: 'Schrijf in een schrift zorgvuldig alles op dat u eet: u bent u beter bewust van uw extraatjes, van hetgeen u te veel eet en van uw voortgang.',
        week_4: 'Organiseer uw kasten en uw koelkast om slim te kunnen snacken indien nodig zonder het risico te lopen verleidende voedingsmiddelen binnen handbereik te hebben.'
    },
    gain_weight: {
        week_1: 'Wek de eetlust op door de tafel mooi te dekken, de gerechten te variëren, te genieten van kleine hoeveelheden en uw lievelingsingrediënten te gebruiken.',
        week_2: 'Eet bij elke maaltijd zetmeelhoudende producten: ontdek de variëteit van biologische en volkoren graanproducten en de peulvruchten.',
        week_3: 'Geef met kruiden en aroma’s vanuit de hele wereld smaak aan uw gerechten en kies uw vette voedingsmiddelen met zorg.',
        week_4: 'Vergeet niet naar buiten te gaan en goed te ademen voordat u aan tafel gaat: dat is de beste en gezondste manier om de eetlust op te wekken.'
    }
};

function processCoachingData(data) {

    var activeCategory = getUrlParameter('category');
    var activeWeek = getUrlParameter('week');
    var tree = {};

    var categoryType, weekType, dayType, periodType, objective;

    data.map(function(row) {
        weekType = 'week_' + row.week;
        categoryType = row.type;
        objective = row.objectif
        dayType = 'day_' + row.day;
        periodType = row.period;

        if (objective !== '' && objective !== undefined && objective !== null)
            objective = objective.trim();

        // check line is complete and is not another header line :
        if (categoryType === '' || categoryType === undefined || categoryType === null ||
          dayType === '' || dayType === undefined || dayType === null ||
          weekType === '' || weekType === undefined  || weekType === null ||
          periodType === '' || periodType === undefined || periodType === null ||
          objective !== 'nutrition'
        )
            return;


        periodType = periodType.trim();
        categoryType = categoryType.trim();
        dayType = dayType.trim();
        weekType = weekType.trim();


        if (activeCategory === 'ideal_weight' && ('gain_weight' === categoryType || 'lose_weight' === categoryType))
            categoryType = 'ideal_weight';

        if (activeCategory !== '' && activeCategory !== categoryType)
            return;

        if (!(categoryType in tree))
            tree[categoryType] = {};

        if (activeWeek !== '' && activeWeek !== weekType)
            return;

        if (!(weekType in tree[categoryType]))
            tree[categoryType][weekType] = {};

        if (!(dayType in tree[categoryType][weekType]))
            tree[categoryType][weekType][dayType] = {};

        if (!(periodType in tree[categoryType][weekType][dayType]))
            tree[categoryType][weekType][dayType][periodType] = [];

        tree[categoryType][weekType][dayType][periodType].push({
            title: row.title,
            link: row.link,
            image: row.image,
        });
    });

    $(window).trigger('coachingDataReady', [tree, activeCategory, activeWeek]);
    return tree;
}

function getUrlParameter(name) {
    name = name.replace(/[\[]/, '\\[').replace(/[\]]/, '\\]');
    var regex = new RegExp('[\\?&]' + name + '=([^&#]*)');
    var results = regex.exec(location.search);
    return results === null ? '' : decodeURIComponent(results[1].replace(/\+/g, ' '));
}
